{**
 * LayerPay Payment Form Template
 * Note: CSS and JS are loaded via hookActionFrontControllerSetMedia
 *}

<div id="layerpay-payment-container" class="layerpay-container"
     data-networks='{$networks|json_encode}'
     data-test-mode="{$is_test_mode|intval}"
     data-merchant-address="{$merchant_address|escape:'htmlall':'UTF-8'}"
     data-order-total="{$order_total|escape:'htmlall':'UTF-8'}"
     data-currency="{$currency_iso|escape:'htmlall':'UTF-8'}"
     data-convert-url="{$convert_url|escape:'htmlall':'UTF-8'}"
     data-validation-url="{$validation_url|escape:'htmlall':'UTF-8'}"
     data-walletconnect-id="{$walletconnect_project_id|escape:'htmlall':'UTF-8'}"
     data-cart-id="{$cart_id|escape:'htmlall':'UTF-8'}">

    {if $is_test_mode}
    <div class="layerpay-test-badge">
        <span class="badge badge-warning">TEST MODE</span>
        <small>{l s='Using testnet networks' mod='layerpay'}</small>
    </div>
    {/if}

    <!-- Network Selection -->
    <div class="layerpay-section">
        <label class="layerpay-label">{l s='Select Network' mod='layerpay'}</label>
        <div class="layerpay-network-grid">
            {foreach from=$networks key=network_key item=network name=networks}
            <label class="layerpay-network-option{if $smarty.foreach.networks.first} selected{/if}">
                <input type="radio" name="layerpay_network_select" value="{$network_key|escape:'htmlall':'UTF-8'}"
                       {if $smarty.foreach.networks.first}checked{/if}
                       data-chain-id="{$network.chain_id|escape:'htmlall':'UTF-8'}"
                       data-contract="{$network.contract|escape:'htmlall':'UTF-8'}"
                       data-usdc="{$network.usdc_address|escape:'htmlall':'UTF-8'}"
                       data-rpc="{$network.rpc_url|escape:'htmlall':'UTF-8'}">
                <span class="layerpay-network-name">{$network.name|escape:'htmlall':'UTF-8'}</span>
            </label>
            {/foreach}
        </div>
    </div>

    <!-- Payment Type Selection -->
    <div class="layerpay-section">
        <label class="layerpay-label">{l s='Payment Currency' mod='layerpay'}</label>
        <div class="layerpay-payment-type">
            <label class="layerpay-type-option selected">
                <input type="radio" name="layerpay_payment_type" value="eth" checked>
                <span class="layerpay-type-icon">Ξ</span>
                <span class="layerpay-type-name">ETH</span>
            </label>
            <label class="layerpay-type-option">
                <input type="radio" name="layerpay_payment_type" value="usdc">
                <span class="layerpay-type-icon">$</span>
                <span class="layerpay-type-name">USDC</span>
            </label>
        </div>
    </div>

    <!-- Price Display -->
    <div class="layerpay-section layerpay-price-section" style="display: none;">
        <div class="layerpay-price-box">
            <div class="layerpay-price-row">
                <span class="layerpay-price-label">{l s='Order Total' mod='layerpay'}:</span>
                <span class="layerpay-price-value">{$order_total|escape:'htmlall':'UTF-8'} {$currency_iso|escape:'htmlall':'UTF-8'}</span>
            </div>
            <div class="layerpay-price-row layerpay-price-highlight">
                <span class="layerpay-price-label">{l s='You Pay' mod='layerpay'}:</span>
                <span class="layerpay-price-value" id="layerpay-crypto-amount">--</span>
            </div>
            <div class="layerpay-price-row layerpay-price-rate">
                <span class="layerpay-price-label">{l s='Rate' mod='layerpay'}:</span>
                <span class="layerpay-price-value" id="layerpay-rate">--</span>
            </div>
        </div>
    </div>

    <!-- Wallet Connection -->
    <div class="layerpay-section">
        <div id="layerpay-wallet-status" class="layerpay-wallet-disconnected">
            <span class="layerpay-wallet-icon">🔗</span>
            <span class="layerpay-wallet-text">{l s='No wallet connected' mod='layerpay'}</span>
        </div>

        <button type="button" id="layerpay-connect-btn" class="btn btn-primary layerpay-btn">
            {l s='Connect Wallet' mod='layerpay'}
        </button>

        <button type="button" id="layerpay-pay-btn" class="btn btn-success layerpay-btn layerpay-btn-pay" style="display: none;">
            {l s='Pay Now' mod='layerpay'}
        </button>
    </div>

    <!-- Transaction Status -->
    <div id="layerpay-tx-status" class="layerpay-section" style="display: none;">
        <div class="layerpay-status-box">
            <div class="layerpay-spinner"></div>
            <span id="layerpay-status-text">{l s='Processing...' mod='layerpay'}</span>
        </div>
    </div>

    <!-- Hidden Fields -->
    <input type="hidden" name="layerpay_tx_hash" id="layerpay-tx-hash" value="">
    <input type="hidden" name="layerpay_network" id="layerpay-network" value="">
    <input type="hidden" name="layerpay_crypto_amount" id="layerpay-crypto-amount-input" value="">
    <input type="hidden" name="layerpay_payment_type" id="layerpay-payment-type-input" value="eth">
    <input type="hidden" name="layerpay_payer_address" id="layerpay-payer-address" value="">
</div>

{* Web3Modal handles wallet selection - no custom modal needed *}
