/**
 * Web3Modal v5 loader for LayerPay CryptoPay
 * Uses dynamic import() to load Web3Modal from esm.sh
 * Delayed loading to avoid RequireJS conflicts
 */
(function() {
    'use strict';

    // Event listener for when modal is ready
    window.addEventListener('web3ModalReady', function(e) {
        if (e.detail && e.detail.modal) {
            window.web3Modal = e.detail.modal;
            window.web3ModalReady = true;
        }
    });

    // Load Web3Modal after page is fully loaded to avoid RequireJS conflicts
    function loadWeb3Modal() {
        import('https://esm.sh/@web3modal/ethers@5.1.11?bundle')
            .then(function(module) {
                var createWeb3Modal = module.createWeb3Modal;
                var defaultConfig = module.defaultConfig;

                var projectId = 'a3101d3fc2013c5c17aaf2fd643873e3';

                var chains = [
                    { chainId: 11155111, name: 'Sepolia Testnet', currency: 'ETH', explorerUrl: 'https://sepolia.etherscan.io', rpcUrl: 'https://rpc.sepolia.org' },
                    { chainId: 1, name: 'Ethereum', currency: 'ETH', explorerUrl: 'https://etherscan.io', rpcUrl: 'https://eth.llamarpc.com' },
                    { chainId: 8453, name: 'Base', currency: 'ETH', explorerUrl: 'https://basescan.org', rpcUrl: 'https://mainnet.base.org' },
                    { chainId: 84532, name: 'Base Sepolia', currency: 'ETH', explorerUrl: 'https://sepolia.basescan.org', rpcUrl: 'https://sepolia.base.org' },
                    { chainId: 10, name: 'Optimism', currency: 'ETH', explorerUrl: 'https://optimistic.etherscan.io', rpcUrl: 'https://mainnet.optimism.io' },
                    { chainId: 11155420, name: 'Optimism Sepolia', currency: 'ETH', explorerUrl: 'https://sepolia-optimism.etherscan.io', rpcUrl: 'https://sepolia.optimism.io' },
                    { chainId: 42161, name: 'Arbitrum One', currency: 'ETH', explorerUrl: 'https://arbiscan.io', rpcUrl: 'https://arb1.arbitrum.io/rpc' },
                    { chainId: 421614, name: 'Arbitrum Sepolia', currency: 'ETH', explorerUrl: 'https://sepolia.arbiscan.io', rpcUrl: 'https://sepolia-rollup.arbitrum.io/rpc' }
                ];

                var metadata = {
                    name: 'LayerPay CryptoPay',
                    description: 'Pay with crypto via LayerPay',
                    url: window.location.origin,
                    icons: [window.location.origin + '/favicon.ico']
                };

                var ethersConfig = defaultConfig({
                    metadata: metadata,
                    enableEIP6963: true,
                    enableInjected: true,
                    enableCoinbase: true,
                    rpcUrl: 'https://rpc.sepolia.org',
                    defaultChainId: 11155111
                });

                var modal = createWeb3Modal({
                    ethersConfig: ethersConfig,
                    chains: chains,
                    projectId: projectId,
                    enableAnalytics: false,
                    themeMode: 'light'
                });

                // Expose globally
                window.web3Modal = modal;
                window.web3ModalReady = true;

                // Dispatch event
                window.dispatchEvent(new CustomEvent('web3ModalReady', { detail: { modal: modal } }));
            })
            .catch(function(error) {
                // Silent fail - Web3Modal loading error
            });
    }

    // Wait for DOM and RequireJS to be ready
    if (document.readyState === 'complete') {
        setTimeout(loadWeb3Modal, 100);
    } else {
        window.addEventListener('load', function() {
            setTimeout(loadWeb3Modal, 100);
        });
    }
})();
