<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class Network implements OptionSourceInterface
{
    public function toOptionArray(): array
    {
        return [
            [
                'value' => '',
                'label' => __('-- Testnets --')
            ],
            [
                'value' => 'sepolia',
                'label' => __('Sepolia Testnet (Chain ID: 11155111)')
            ],
            [
                'value' => 'goerli',
                'label' => __('Goerli Testnet (Chain ID: 5)')
            ],
            [
                'value' => 'mumbai',
                'label' => __('Polygon Mumbai (Chain ID: 80001)')
            ],
            [
                'value' => 'arbitrum_sepolia',
                'label' => __('Arbitrum Sepolia (Chain ID: 421614)')
            ],
            [
                'value' => '',
                'label' => __('-- Mainnets --')
            ],
            [
                'value' => 'ethereum',
                'label' => __('Ethereum Mainnet (Chain ID: 1)')
            ],
            [
                'value' => 'polygon',
                'label' => __('Polygon (Chain ID: 137)')
            ],
            [
                'value' => 'arbitrum',
                'label' => __('Arbitrum One (Chain ID: 42161)')
            ],
            [
                'value' => 'base',
                'label' => __('Base (Chain ID: 8453)')
            ]
        ];
    }

    public function toArray(): array
    {
        $options = [];
        foreach ($this->toOptionArray() as $option) {
            if (!empty($option['value'])) {
                $options[$option['value']] = $option['label'];
            }
        }
        return $options;
    }
}
