<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use LayerPay\CryptoPay\Api\ConfigInterface;

class Data extends AbstractHelper
{
    private ConfigInterface $config;

    public function __construct(
        Context $context,
        ConfigInterface $config
    ) {
        parent::__construct($context);
        $this->config = $config;
    }

    public function isEnabled(): bool
    {
        return $this->config->isEnabled();
    }

    public function getConfig(): ConfigInterface
    {
        return $this->config;
    }

    public function formatCryptoAmount(float $amount, string $currency): string
    {
        $decimals = $currency === 'USDC' ? 2 : 8;
        return number_format($amount, $decimals, '.', '');
    }

    public function getExplorerUrl(string $txHash): string
    {
        $networkConfig = $this->config->getNetworkConfig();
        $explorer = $networkConfig['explorer'] ?? 'https://etherscan.io';
        return $explorer . '/tx/' . $txHash;
    }
}
