<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Gateway\Validator;

use Magento\Payment\Gateway\Validator\AbstractValidator;
use Magento\Payment\Gateway\Validator\ResultInterface;
use Magento\Payment\Gateway\Validator\ResultInterfaceFactory;

class ResponseValidator extends AbstractValidator
{
    public function __construct(ResultInterfaceFactory $resultFactory)
    {
        parent::__construct($resultFactory);
    }

    public function validate(array $validationSubject): ResultInterface
    {
        $response = $validationSubject['response'] ?? [];

        $isValid = isset($response['success']) && $response['success'] === true;
        $errorMessages = [];

        if (!$isValid) {
            $errorMessages[] = $response['error'] ?? __('Transaction validation failed');
        }

        return $this->createResult($isValid, $errorMessages);
    }
}
