<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Gateway\Request;

use Magento\Payment\Gateway\Request\BuilderInterface;

class AuthorizationRequest implements BuilderInterface
{
    public function build(array $buildSubject): array
    {
        $payment = $buildSubject['payment'] ?? null;
        $amount = $buildSubject['amount'] ?? 0;

        $data = [
            'amount' => $amount,
            'currency' => 'EUR'
        ];

        if ($payment) {
            $paymentDO = $payment;
            $order = $paymentDO->getOrder();
            $data['order_id'] = $order->getOrderIncrementId();
            $data['tx_hash'] = $paymentDO->getPayment()->getAdditionalInformation('tx_hash');
            $data['wallet_address'] = $paymentDO->getPayment()->getAdditionalInformation('wallet_address');
        }

        return $data;
    }
}
