<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Gateway\Http\Client;

use Magento\Payment\Gateway\Http\ClientInterface;
use Magento\Payment\Gateway\Http\TransferInterface;
use Psr\Log\LoggerInterface;

class TransactionCapture implements ClientInterface
{
    private LoggerInterface $logger;

    public function __construct(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    public function placeRequest(TransferInterface $transferObject): array
    {
        $request = $transferObject->getBody();

        $this->logger->info('LayerPay Capture Request', $request);

        // For crypto payments, capture is automatic once confirmed on-chain
        $txHash = $request['tx_hash'] ?? null;

        return [
            'success' => true,
            'tx_hash' => $txHash,
            'captured' => true
        ];
    }
}
