<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Gateway\Http\Client;

use Magento\Payment\Gateway\Http\ClientInterface;
use Magento\Payment\Gateway\Http\TransferInterface;
use Psr\Log\LoggerInterface;

class TransactionAuthorize implements ClientInterface
{
    private LoggerInterface $logger;

    public function __construct(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    public function placeRequest(TransferInterface $transferObject): array
    {
        $request = $transferObject->getBody();

        $this->logger->info('LayerPay Authorization Request', $request);

        // For crypto payments, authorization is done on-chain
        // We just validate the transaction hash exists
        $txHash = $request['tx_hash'] ?? null;

        if (!$txHash) {
            return [
                'success' => false,
                'error' => 'No transaction hash provided'
            ];
        }

        return [
            'success' => true,
            'tx_hash' => $txHash,
            'authorized' => true
        ];
    }
}
