<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Controller\Payment;

use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\JsonFactory;
use LayerPay\CryptoPay\Api\CryptoPayInterface;
use Psr\Log\LoggerInterface;

class Process implements HttpPostActionInterface
{
    private RequestInterface $request;
    private JsonFactory $jsonFactory;
    private CryptoPayInterface $cryptoPay;
    private LoggerInterface $logger;

    public function __construct(
        RequestInterface $request,
        JsonFactory $jsonFactory,
        CryptoPayInterface $cryptoPay,
        LoggerInterface $logger
    ) {
        $this->request = $request;
        $this->jsonFactory = $jsonFactory;
        $this->cryptoPay = $cryptoPay;
        $this->logger = $logger;
    }

    public function execute()
    {
        $result = $this->jsonFactory->create();

        try {
            $orderId = $this->request->getParam('order_id');
            $txHash = $this->request->getParam('tx_hash');
            $walletAddress = $this->request->getParam('wallet_address');
            $currency = $this->request->getParam('currency');
            $amount = $this->request->getParam('amount');

            $response = $this->cryptoPay->processPayment(
                $orderId,
                $txHash,
                $walletAddress,
                $currency,
                $amount
            );

            return $result->setData($response);

        } catch (\Exception $e) {
            $this->logger->error('LayerPay process error: ' . $e->getMessage());
            return $result->setData([
                'success' => false,
                'error' => $e->getMessage()
            ]);
        }
    }
}
