<?php
/**
 * LayerPay CryptoPay
 *
 * @copyright Copyright (c) 2024 LayerPay
 * @license   Proprietary
 */
declare(strict_types=1);

namespace LayerPay\CryptoPay\Api;

interface CryptoPayInterface
{
    /**
     * Get payment configuration
     *
     * @return array
     */
    public function getConfig(): array;

    /**
     * Get crypto price for amount
     *
     * @param string $currency
     * @param float $amount
     * @return array
     */
    public function getCryptoPrice(string $currency, float $amount): array;

    /**
     * Verify blockchain transaction
     *
     * @param string $txHash
     * @param string $orderId
     * @return array
     */
    public function verifyTransaction(string $txHash, string $orderId): array;

    /**
     * Process payment after blockchain transaction
     *
     * @param string $orderId
     * @param string $txHash
     * @param string $walletAddress
     * @param string $currency
     * @param string $amount
     * @return array
     */
    public function processPayment(
        string $orderId,
        string $txHash,
        string $walletAddress,
        string $currency,
        string $amount
    ): array;
}
